var gulp = require('gulp');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var rename = require('gulp-rename');
var minifyCss = require('gulp-minify-css');

var paths = {
    admin: 'src/js/admin/*.js',
    lib: 'src/js/lib/*.js',
    css: 'src/css/*.css',
    vendor: [
        'src/js/*.js',
        'src/js/gui/*.js',
        'src/js/lib/jquery.tipsy.js',
        'src/js/lib/jquery.webticker.min.js',
        'protected/modules/student/assets/js/gui/gui-*.js'
    ]
}

gulp.task('default', ['minify-css', 'uglify', 'uglify-admin', 'uglify-lib'], function() {
    gulp.watch(paths.vendor, ['uglify']);
    gulp.watch(paths.admin, ['uglify-admin']);
    gulp.watch(paths.lib, ['uglify-lib']);
    gulp.watch(paths.css, ['minify-css']);
})

gulp.task('minify-css', function() {
    return gulp.src(paths.css)
        .pipe(minifyCss())
        .pipe(gulp.dest('css'));
});

gulp.task('uglify', function() {
    return gulp.src(paths.vendor)
        .pipe(concat('vendor.js'))
        .pipe(gulp.dest('js'))
        .pipe(uglify())
        .pipe(rename({
            extname: '.min.js'
        }))
        .pipe(gulp.dest('js'));
});

gulp.task('uglify-admin', function() {
    return gulp.src(paths.admin)
        .pipe(uglify())
        .pipe(gulp.dest("js/admin"));
});

gulp.task('uglify-lib', function() {
    return gulp.src(paths.lib)
        .pipe(uglify())
        .pipe(gulp.dest("js/lib"));
});
